﻿using BitFactory.Logging;
using System.Configuration;
using System;


public class Logging
{
    public static void WriteLogToFile(string LoginUserID, Exception ex)
    {
        string message = "Login UserId: " + LoginUserID + ":::Error: " +
                         ex.Message.ToString() + " ::: " + ex.StackTrace.ToString();

        WriteLogToFile(message);
    }

    public static void WriteLogToFile(string LoginUserID, string error)
    {
        string message = "Login UserId: " + LoginUserID + ":::Error: " + error;

        WriteLogToFile(message);
    }

    public static void WriteLogToFile(string message)
    {
        string path = GetLogLocation();

        Logger l = new FileLogger(path);

        l.LogError(message);

        if (ConfigurationManager.AppSettings["LogToDB"].ToString().Trim() == "true")
        {
            var numReferrals = SqlProvider.ExecuteScalar(
                            "RegistryConnectionString", "CRS_SP_INS_CRSDBLOG",
                            new object[] { 1, 0, "EFR Logger", message, "", "EFR Logger" });
        }
    }

    public static string GetLogLocation()
    {
        //Global g = new Global();
        return ConfigurationManager.AppSettings["LogsPath"].ToString() + @"\" + DateTime.Today.Year + @"\" + DateTime.Today.Month + @"\" + DateTime.Today.Day + ".log";
    }
}


